/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.config.ConfigurableField;
import jace.config.Name;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Computer;
import jace.core.RAMEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Name(value="Super Serial Card")
public class CardSSC
extends Card
implements Reconfigurable {
    @ConfigurableField(name="TCP/IP Port")
    public static short IP_PORT = (short)1977;
    protected ServerSocket socket;
    protected Socket clientSocket;
    protected Thread listenThread;
    private int lastInputByte = 0;
    private boolean FULL_ECHO = true;
    private boolean RECV_ACTIVE = true;
    private boolean TRANS_ACTIVE = true;
    @ConfigurableField(name="Strip LF (recv)", defaultValue="false", description="Strip incoming linefeeds")
    public boolean RECV_STRIP_LF = false;
    @ConfigurableField(name="Add LF (send)", defaultValue="false", description="Append linefeeds after outgoing carriage returns")
    public boolean TRANS_ADD_LF = false;
    private boolean DTR = true;
    private static int SW1 = 1;
    private static int SW1_SETTING = 240;
    private static int SW2_CTS = 2;
    private static int SW2_SETTING = 4;
    private static int ACIA_Data = 8;
    private static int ACIA_Status = 9;
    private static int ACIA_Command = 10;
    private static int ACIA_Control = 11;
    private boolean PORT_CONNECTED = false;
    private boolean RECV_IRQ_ENABLED = false;
    private boolean TRANS_IRQ_ENABLED = false;
    private boolean IRQ_TRIGGERED = false;
    private int DATA_BITS = 127;

    public void CardSSC() {
        this.reset();
    }

    public void init() throws IOException, InterruptedException {
        this.loadRom("jace/data/SSC.rom");
        this.RECV_IRQ_ENABLED = false;
        this.TRANS_IRQ_ENABLED = false;
        this.IRQ_TRIGGERED = false;
        this.disconnect();
        try {
            this.socket = new ServerSocket(IP_PORT);
            this.socket.setReuseAddress(true);
            this.socket.setSoTimeout(100);
            this.listenThread = new Thread(new Runnable(){

                public void run() {
                    Logger.getLogger(CardSSC.class.getName()).log(Level.INFO, "Socket listening on port " + IP_PORT, (Throwable)null);
                    while (!CardSSC.this.socket.isClosed()) {
                        try {
                            while ((CardSSC.this.clientSocket = CardSSC.this.socket.accept()) != null) {
                                CardSSC.this.clientSocket.setTcpNoDelay(true);
                                while (CardSSC.this.clientSocket != null && CardSSC.this.clientSocket.isConnected()) {
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (InterruptedException ex) {}
                                }
                            }
                        }
                        catch (SocketTimeoutException ex) {
                        }
                        catch (IOException ex) {
                            Logger.getLogger(CardSSC.class.getName()).log(Level.FINE, null, ex);
                        }
                    }
                    CardSSC.this.socket = null;
                }
            });
            this.listenThread.setDaemon(false);
            this.listenThread.start();
        }
        catch (IOException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
    }

    public String getName() {
        return "Super Serial Card (Slot " + this.getSlot() + ")";
    }

    public void loadRom(String path) throws IOException {
        InputStream romFile = CardSSC.class.getClassLoader().getResourceAsStream(path);
        int cxRomLength = 256;
        int c8RomLength = 1792;
        byte[] romxData = new byte[256];
        byte[] rom8Data = new byte[1792];
        if (romFile.read(rom8Data) != 1792) {
            throw new IOException("Bad SSC rom size");
        }
        this.getC8Rom().loadData(rom8Data);
        if (romFile.read(romxData) != 256) {
            throw new IOException("Bad SSC rom size");
        }
        this.getCxRom().loadData(romxData);
    }

    public void reset() {
        try {
            this.init();
        }
        catch (IOException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void registerCustomListeners() {
    }

    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        try {
            int newValue = -1;
            block1 : switch (type) {
                case READ: {
                    if (register == SW1) {
                        newValue = SW1_SETTING;
                    }
                    if (register == SW2_CTS) {
                        newValue = SW2_SETTING & 0xFE;
                        newValue |= this.PORT_CONNECTED && this.inputAvailable() ? 0 : 1;
                    }
                    if (register == ACIA_Data) {
                        newValue = this.getInputByte();
                        if (this.RECV_IRQ_ENABLED) {
                            this.triggerIRQ();
                        }
                    }
                    if (register == ACIA_Status) {
                        newValue = 0;
                        if (this.inputAvailable()) {
                            newValue |= 8;
                        }
                        newValue |= 0x10;
                        if (this.IRQ_TRIGGERED) {
                            newValue |= 0x80;
                        }
                        this.IRQ_TRIGGERED = false;
                    }
                    if (register == ACIA_Command) {
                        newValue = 0;
                        if (this.RECV_IRQ_ENABLED) {
                            newValue |= 2;
                        }
                        newValue |= 0xC;
                        if (this.FULL_ECHO) {
                            newValue |= 0x10;
                        }
                    }
                    if (register != ACIA_Control) break;
                    newValue = 0;
                    break;
                }
                case WRITE: {
                    if (register == ACIA_Data) {
                        this.sendOutputByte(value & 0xFF);
                        if (this.TRANS_IRQ_ENABLED) {
                            this.triggerIRQ();
                        }
                    }
                    if (register == ACIA_Command) {
                        boolean bl = this.DTR = (value & 1) == 0;
                        this.RECV_IRQ_ENABLED = (value & 2) == 0 ? !this.DTR : false;
                        switch (value >> 2 & 3) {
                            case 0: {
                                this.TRANS_IRQ_ENABLED = false;
                                this.TRANS_ACTIVE = false;
                                break;
                            }
                            case 1: {
                                this.TRANS_IRQ_ENABLED = true;
                                this.TRANS_ACTIVE = true;
                                break;
                            }
                            case 2: {
                                this.TRANS_IRQ_ENABLED = false;
                                this.TRANS_ACTIVE = true;
                                break;
                            }
                            case 3: {
                                this.TRANS_IRQ_ENABLED = false;
                                this.TRANS_ACTIVE = true;
                            }
                        }
                        this.FULL_ECHO = (value & 0x10) > 0;
                        System.out.println("Echo set to " + this.FULL_ECHO);
                    }
                    if (register != ACIA_Control) break;
                    int bits = (value & 0x7F) >> 5;
                    System.out.println("Data bits set to " + (8 - bits));
                    switch (bits) {
                        case 0: {
                            this.DATA_BITS = 255;
                            break block1;
                        }
                        case 1: {
                            this.DATA_BITS = 127;
                            break block1;
                        }
                        case 2: {
                            this.DATA_BITS = 63;
                            break block1;
                        }
                        case 3: {
                            this.DATA_BITS = 31;
                        }
                    }
                }
            }
            if (newValue > -1) {
                e.setNewValue(newValue);
                value = newValue;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void motherboardTick() {
    }

    private boolean inputAvailable() throws IOException {
        if (this.clientSocket != null && this.clientSocket.isConnected()) {
            return this.clientSocket.getInputStream().available() > 0;
        }
        return false;
    }

    private int getInputByte() throws IOException {
        if (this.clientSocket != null && this.clientSocket.isConnected() && this.clientSocket.getInputStream().available() > 0) {
            int in = this.clientSocket.getInputStream().read() & this.DATA_BITS;
            if (this.RECV_STRIP_LF && in == 10 && this.lastInputByte == 13) {
                in = this.clientSocket.getInputStream().read() & this.DATA_BITS;
            }
            this.lastInputByte = in;
        }
        return this.lastInputByte;
    }

    private void sendOutputByte(int i) throws IOException {
        if (this.clientSocket != null && this.clientSocket.isConnected()) {
            this.clientSocket.getOutputStream().write(i & this.DATA_BITS);
            if (this.TRANS_ADD_LF && (i & this.DATA_BITS) == 13) {
                this.clientSocket.getOutputStream().write(10);
            }
        }
    }

    private void setCTS(boolean b) throws InterruptedException {
        this.PORT_CONNECTED = b;
        if (!b) {
            this.reset();
        }
    }

    private boolean getCTS() throws InterruptedException {
        return this.PORT_CONNECTED;
    }

    private void triggerIRQ() {
        this.IRQ_TRIGGERED = true;
        Computer.getComputer().getCpu().generateInterrupt();
    }

    public void reconfigure() {
        try {
            this.init();
        }
        catch (IOException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.clientSocket != null && this.clientSocket.isConnected()) {
            try {
                this.clientSocket.shutdownInput();
                this.clientSocket.shutdownOutput();
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.listenThread != null && this.listenThread.isAlive()) {
            try {
                this.listenThread.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

